<?php
require_once __DIR__.'/../common/response.php';
require_once __DIR__.'/../common/validate.php';
require_once __DIR__.'/../../app/config/db.php';
$body = json_decode(file_get_contents('php://input'),true) ?? [];
try {
    require_fields($body,["plot_id","year","crop"]);
    $stmt = $pdo->prepare("INSERT INTO activities (plot_id,year,season,crop,fertilizer_type,tillage_method,cover_crop_used,residue_management,irrigation_type,notes,updated_at)
                           VALUES (:plot,:yr,:season,:crop,:fert,:till,:cover,:res,:irr,:notes,NOW())");
    $stmt->execute([
        ":plot"=>$body["plot_id"],
        ":yr"=>$body["year"],
        ":season"=>$body["season"] ?? null,
        ":crop"=>$body["crop"],
        ":fert"=>$body["fertilizer_type"] ?? null,
        ":till"=>$body["tillage_method"] ?? null,
        ":cover"=>$body["cover_crop_used"] ?? 0,
        ":res"=>$body["residue_management"] ?? null,
        ":irr"=>$body["irrigation_type"] ?? null,
        ":notes"=>$body["notes"] ?? null
    ]);
    json_response(["message"=>"activity logged"]);
} catch(Exception $e){
    json_response(["error"=>$e->getMessage()],400);
}
?>
