<?php
require_once __DIR__.'/../common/response.php';
require_once __DIR__.'/../common/validate.php';
require_once __DIR__.'/../../app/config/db.php';
$body = json_decode(file_get_contents('php://input'),true) ?? [];
try {
    require_fields($body,["full_name"]);
    $stmt = $pdo->prepare("INSERT INTO land_owners (full_name, id_number, group_name, contact_info, consent_doc, created_at)
                           VALUES (:name,:idnum,:grp,:contact,:consent,NOW())");
    $stmt->execute([
        ":name"=>$body["full_name"] ?? null,
        ":idnum"=>$body["id_number"] ?? null,
        ":grp"=>$body["group_name"] ?? null,
        ":contact"=>$body["contact_info"] ?? null,
        ":consent"=>$body["consent_doc"] ?? null
    ]);
    json_response(["message"=>"land owner created"]);
} catch(Exception $e){
    json_response(["error"=>$e->getMessage()],400);
}
?>
