<?php
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1.0" />
  <title>Krufarm Project Console 🌾</title>
  <link rel="stylesheet" href="assets/css/software.css" />
</head>
<body class="bg">
  <section class="hero">
    <h1>🌾 Project Console</h1>
    <p class="tagline">Field data → Compliance → Verified carbon outcomes</p>

    <p class="pitch">
      This project instance captures farmer enrollment, land polygons, yearly
      management practices, fertilizer use, residue handling, irrigation,
      and supporting documents. The data is synced to Krufarm Engine for
      VM0042-compliant monitoring, QA/QC, and issuance.
    </p>

    <div class="cta-row">
      <a class="btn" href="dashboard.php">📊 Open Dashboard</a>
      <a class="btn" href="../engine/">↩ Back to Engine</a>
    </div>

    <div class="grid">
      <div class="card">
        <h2>👩‍🌾 Farmer / Stakeholder Registry</h2>
        <p>Register individual farmers, co-ops, communities. Store ID docs, consent, and contact info.</p>
      </div>
      <div class="card">
        <h2>🗺️ Land Plots & Boundaries</h2>
        <p>Upload KML or draw polygons. Attach ownership and land-use history for EUDR traceability.</p>
      </div>
      <div class="card">
        <h2>🌱 Annual Practices</h2>
        <p>Log tillage, fertilizer type/amount, cover crops, residue, water use. Offline capable.</p>
      </div>
      <div class="card">
        <h2>📂 Evidence & Compliance</h2>
        <p>Attach photos, titles, certificates, verifier notes. Timestamped for full audit trail.</p>
      </div>
    </div>

    <p class="foot-note">We do not own projects. We own integrity.</p>
  </section>

  <div class="float float1">🛰️</div>
  <div class="float float2">📍</div>
  <div class="float float3">📸</div>
  <div class="float float4">🧾</div>

  <script src="assets/js/ui.js"></script>
</body>
</html>
